import codecs
from sys import argv, exit
from requests import get
from os import path, remove
from json import loads, load
from shutil import rmtree
from time import time
from urllib.parse import unquote_plus, unquote, quote, urlparse
from xbmcaddon import Addon
from xbmcplugin import endOfDirectory, addDirectoryItem
from xbmcgui import ListItem, Dialog
from xbmcvfs import listdir, exists, mkdirs, translatePath
from xbmc import executebuiltin, getInfoLabel, executeJSONRPC, Player, log, convertLanguage

myAddon = Addon()
myScriptID = myAddon.getAddonInfo('id')
myVersion = myAddon.getAddonInfo('version')
myTmp = translatePath(myAddon.getAddonInfo('profile'))
mySubFolder = translatePath(path.join(myTmp, 'subs'))
myName = myAddon.getAddonInfo('name')
myLang = myAddon.getLocalizedString

if not exists(myTmp):
	mkdirs(myTmp)

def getParams(string=""):
	param=[]
	if string == "":
		paramstring=argv[2]
	else:
		paramstring=string
	if len(paramstring)>=2:
		params=paramstring
		cleanedparams=params.replace('?','')
		if (params[len(params)-1]=='/'):
			params=params[0:len(params)-2]
		pairsofparams=cleanedparams.split('&')
		param={}
		for i in range(len(pairsofparams)):
			splitparams={}
			splitparams=pairsofparams[i].split('=')
			if (len(splitparams))==2:
				param[splitparams[0]]=splitparams[1]
	return param

def cachingJSON(jsonName, url, headers):
	jsonFile = path.join(myTmp, jsonName)
	if not path.exists(jsonFile) or not path.getsize(jsonFile) > 20 or (time()-path.getmtime(jsonFile) > 30*60):
		response = get(url, headers=headers)
		file = open(jsonFile, "w")
		file.write(response.text)
		file.close()

	if path.exists(jsonFile) and path.getsize(jsonFile) > 20:
		with open(jsonFile) as json_data:
			json_object = load(json_data)
		return json_object
	else:
		return 0

def wlog(msg):
	log((u"##**## [%s] %s" % (myName, msg)), level=xbmc.LOGDEBUG)

def convert2UTF(file):
	try:
		with codecs.open(file, "r", "cp1255") as f:
			srt_data = f.read()

		with codecs.open(file, 'w', 'utf-8') as output:
			output.write(srt_data)
	except Exception as err:
		wlog('Caught Exception: error converting to utf: %s' % format(err))
		pass

def downloadSub(url,filename,isZip):
	subtitle_list = []
	
	if isZip==0:
		subtitle_list.append(url)
		return subtitle_list
	
	try:
		rmtree(mySubFolder)
	except Exception as err:
		wlog('Caught Exception: error deleting folders: %s' % format(err))
		pass
	mkdirs(mySubFolder)
	subtitle_list = []
	exts = [".srt", ".sub", ".str"]
	archive_file = path.join(myTmp, id+'.zip')
	if not path.exists(archive_file):
		data = get("http://zip.%s/"%format(myDomain)+id+".zip")
		open(archive_file, 'wb').write(data.content)
	executebuiltin(('Extract("%s","%s")' % (archive_file, mySubFolder)).encode('utf-8').decode(), True)
	for file_ in listdir(mySubFolder)[1]:
		file = path.join(mySubFolder, file_)
		if path.splitext(file)[1] in exts:
			subtitle_list.append(file)
	return subtitle_list

def uploadAP(imdb,season,episode,lang,id,site):
	try:
		hostname = urlparse(Player().getPlayingFile()).hostname[-11:]
	except:
		hostname = 0
	
	if hostname!=getDomain() or myAddon.getSetting("uploadAP") != "true":
		return
	
	xbmc.sleep(int(myAddon.getSetting("timeout"))*1000)
	if myAddon.getSetting("idSub")!=id or not Player().isPlaying():
		return 
		
	myAddon.setSetting("idSub","0")	
	
	langName = convertLanguage(lang, xbmc.ENGLISH_NAME)
	url = "https://subs2.apollogroup.tv/kodi.upload.php?status=1&imdb=%s&season=%s&episode=%s"%(imdb, season, episode)
	response = get(url)
	ap_object = loads(response.text)["result"]
	if langName not in ap_object["lang"]:
		i = Dialog().yesno("Apollo Upload Subtitle","Media version %s"%ap_object["version"],"This %s subtitle is 100 sync and match?"%langName)
		if i == 1:
			response = get("https://subs2.apollogroup.tv/kodi.upload.php?upload=1&lang=%s&subid=%s&imdb=%s&season=%s&episode=%s&site=%s"%(lang,id,imdb,season,episode,site))
			ap_upload = loads(response.text)["result"]
			if "error" in ap_upload:
				Dialog().ok("onthego Error","%s"%ap_upload["error"])
			else:
				Dialog().ok("onthego","Sub uploaded. Thank you!")

def getDomain():
	try:
		response = get("https://raw.githubusercontent.com/Apollo2000/Repo/master/domainv2.txt", verify=False)
		data = loads(response.text)
		return data['result']
	except: 
		return "tv4.live"
		pass

# Main
params = getParams()
action = params['action']
domain = getDomain()
token = Addon(id='program.onthego').getSetting("token")
headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'Authorization': 'Bearer '+token}

langs = []
langsName = []
if 'languages' in params:
	for lang in unquote(params['languages']).split(","):
		if lang == "Portuguese (Brazil)":
			lan = "pt"
		elif lang == "Greek":
			lan = "el"
		else:
			lan = convertLanguage(lang,xbmc.ISO_639_1)

		langs.append(lan)
		langsName.append(lang)

if 'lang' in params:
	lang = params['lang']
	
# Get imdb, season & episode
if Player().isPlaying():	# Take item params from Player
	playerid_query = '{"jsonrpc": "2.0", "method": "Player.GetActivePlayers", "id": 1}'
	playerid = loads(executeJSONRPC(playerid_query))['result'][0]['playerid']
	imdb_id_query = '{"jsonrpc": "2.0", "method": "Player.GetItem", "params": {"playerid": '+str(playerid)+', "properties": ["imdbnumber"]}, "id": 1}'
	imdb = loads(executeJSONRPC(imdb_id_query))['result']['item']['imdbnumber']
	season = str(getInfoLabel("VideoPlayer.Season"))
	episode = str(getInfoLabel("VideoPlayer.Episode"))
else:   # Take item params from list
	imdb = getInfoLabel("ListItem.IMDBNumber")
	season = getInfoLabel("ListItem.Season")
	episode = getInfoLabel("ListItem.Episode")

if imdb[:2] != "tt":
	exit()
if season == '' or int(season) < 1:
	season = 0
if episode == '' or int(episode) < 1:
	episode = 0

if action == 'search':
	# Search Recommended
	link = "https://"+domain+"/api/subtitles/";
	if (season==0):
		link += "movie/%s"%(imdb)
	else:
		link += "tvshow/%s/%s/%s"%(imdb,season,episode)

	response = get(link, headers=headers)
	data = loads(response.text)
	if "data" in data:
		try:
			subs = data["data"][0]["data"]
			for langName in subs:
				wlog("JSON %s"%langName)
				listitem = ListItem(label=langName, label2="Go onthego Recommended Subtitle" )
				listitem.setArt({'thumb': convertLanguage(langName,xbmc.ISO_639_1)})
				listitem.setProperty("sync", "true")
				myurl = "plugin://%s/?action=download&subid=%s&myurl=%s" % (myScriptID, langName,subs[langName])

				addDirectoryItem(handle=int(argv[1]), url=myurl, listitem=listitem, isFolder=False)
				if langName in langsName:
					langsName.remove(langName)
					langs.remove(convertLanguage(langName,xbmc.ISO_639_1))
		except:
			a=1

	# Search other
	if len(langs)>0:
		for lang in langs:
			try:
				filename = 'apollo.imdb.%s.%s.%s.%s.json' % (imdb, lang, season, episode)
				url = "https://subs2.apollogroup.tv/search.php?imdb=%s&lang=%s&season=%s&episode=%s" % (imdb, lang, season, episode)
				json_object = cachingJSON(filename, url, headers)
				
				if json_object != 0:
					for item_data in json_object:
						listitem = ListItem(label=convertLanguage(item_data["lang"], xbmc.ENGLISH_NAME), label2=item_data["name"],thumbnailImage=item_data["lang"])
						myurl = "plugin://%s/?action=download&myurl=https://subs2.apollogroup.tv/download.php?imdb=%s&lang=%s&season=%s&episode=%s&site=%s&id=%s" % (myScriptID, imdb, item_data["lang"], season, episode,item_data["site"], item_data["id"])
						addDirectoryItem(handle=int(argv[1]), url=myurl, listitem=listitem, isFolder=False)
			except:
				a=1
	endOfDirectory(int(argv[1]))

elif action == 'download':
	start = argv[2].index("myurl=") + len("myurl=")
	myurl = argv[2][start:]
	
	try:
		indexQ = myurl.index("?")+1
	except:
		indexQ = 0
		
	paramsMyURL = getParams(myurl[indexQ:])
	if "id" in paramsMyURL:
		subs = downloadSub(myurl,"apollo."+paramsMyURL["id"]+".zip",1)
	elif "subid" in params:
		subs = downloadSub(myurl,"apollo."+params["subid"]+".srt",0)

	for sub in subs:
		listitem = ListItem(label=sub)
		addDirectoryItem(handle=int(sys.argv[1]), url=sub, listitem=listitem, isFolder=False)
	endOfDirectory(int(sys.argv[1]))
	
	if "id" in paramsMyURL:
		myAddon.setSetting("idSub",paramsMyURL["id"])
		uploadAP(paramsMyURL["imdb"],paramsMyURL["season"],paramsMyURL["episode"],paramsMyURL["lang"],paramsMyURL["id"],paramsMyURL["site"])

elif action == 'clean':
	try:
		rmtree(myTmp)
	except Exception as err:
		pass
	executebuiltin((u'Notification(%s,"Cache Clean")' % myName))